/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.FtpContext;
import com.quantumdata.ftp.FtpInterpret;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

final class FtpControlSocket {
    private Socket m_control = null;
    private BufferedReader m_in = null;
    private BufferedWriter m_out = null;
    private FtpContext m_context = null;
    private String m_replyline = null;
    private String m_server = null;

    FtpControlSocket(FtpContext ftpContext) {
        this.m_context = ftpContext;
    }

    public String getServer() {
        return this.m_server;
    }

    synchronized boolean connect(String string, int n) {
        boolean bl = false;
        if (this.m_control == null) {
            try {
                this.m_context.printlog("Getting host by name: " + string);
                InetAddress inetAddress = InetAddress.getByName(string);
                this.m_context.printlog("Connecting to host: " + inetAddress.getHostAddress());
                this.m_control = new Socket(inetAddress, n);
                this.m_control.setSoTimeout(60000);
                this.m_in = new BufferedReader(new InputStreamReader(this.m_control.getInputStream()));
                this.m_out = new BufferedWriter(new OutputStreamWriter(this.m_control.getOutputStream()));
                this.m_server = string;
                bl = true;
            }
            catch (UnknownHostException unknownHostException) {
                this.m_context.printlog("< Ctrl: Can't resolve host address! >");
            }
            catch (IOException iOException) {
                this.disconnect();
                this.m_context.printlog("< Ctrl: Can't obtain connection to host! >");
            }
            catch (Exception exception) {
                this.m_context.printlog("< Ctrl: Permission denied! >");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void disconnect() {
        while (this.m_in != null || this.m_out != null) {
            try {
                if (this.m_in != null) {
                    BufferedReader bufferedReader = this.m_in;
                    this.m_in = null;
                    ((Reader)bufferedReader).close();
                }
                if (this.m_out == null) continue;
                BufferedWriter bufferedWriter = this.m_out;
                this.m_out = null;
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {
                this.m_context.printerr(iOException);
            }
        }
        if (this.m_control != null) {
            try {
                this.m_control.close();
            }
            catch (IOException iOException) {
                this.m_context.printerr(iOException);
            }
            finally {
                this.m_control = null;
                this.m_context.printlog("< Ctrl: Disconnected! >");
            }
        }
        this.m_server = null;
    }

    private synchronized void writeLine(String string) throws IOException {
        if (this.m_out != null) {
            try {
                this.m_out.write(string + "\r\n");
                this.m_out.flush();
            }
            catch (IOException iOException) {
                throw new IOException("Ctrl: Write, failed!\n" + iOException);
            }
        } else {
            throw new IOException("Ctrl: Write, No connection!");
        }
    }

    private synchronized String readLine() throws IOException {
        String string = null;
        if (this.m_in != null) {
            try {
                string = this.m_in.readLine();
            }
            catch (IOException iOException) {
                throw new IOException("Ctrl: Read, Error!\n" + iOException);
            }
            if (string == null) {
                this.disconnect();
                throw new IOException("Ctrl: Read, End Of File!");
            }
        } else {
            throw new IOException("Ctrl: Read, No connection!");
        }
        return string;
    }

    private synchronized String readReply() throws IOException {
        String string = null;
        do {
            string = this.readLine();
            this.m_context.printlog(string);
        } while (string.length() == 0 || string.indexOf("-") == 3 || "0123456789".indexOf(string.charAt(0)) < 0);
        return string;
    }

    synchronized boolean manualCommand(String string) {
        if (!FtpInterpret.allowManualExecution(string)) {
            this.m_context.printlog("< Ctrl: Command, No Manual Execution! >");
            return false;
        }
        return this.executeCommand(string);
    }

    synchronized boolean executeCommand(String string) {
        if (this.writeCommand(string)) {
            return this.completeCommand(FtpInterpret.getReplies(string));
        }
        return false;
    }

    synchronized boolean writeCommand(String string) {
        if (string.startsWith("PASS")) {
            this.m_context.printlog("Ftp> PASS ******");
        } else {
            this.m_context.printlog("Ftp> " + string);
        }
        if (!FtpInterpret.allowExecution(string)) {
            this.m_context.printlog("< Ctrl: Command, Not Implemented! >");
            return false;
        }
        boolean bl = true;
        try {
            this.m_replyline = null;
            this.writeLine(string.trim());
        }
        catch (IOException iOException) {
            bl = false;
            if (iOException.getMessage() != null) {
                this.m_context.printlog("< " + iOException.getMessage() + " >");
            }
            this.m_context.printerr(iOException);
        }
        return bl;
    }

    synchronized boolean completeCommand(String[] stringArray) {
        boolean bl = false;
        try {
            this.m_replyline = this.readReply();
            bl = FtpInterpret.startsWith(this.m_replyline, stringArray);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null) {
                this.m_context.printlog("< " + iOException.getMessage() + " >");
            }
            this.m_context.printerr(iOException);
        }
        return bl;
    }

    String replyOfCommand() throws IOException {
        if (this.m_replyline != null) {
            return this.m_replyline;
        }
        throw new IOException("Ctrl: No Reply!");
    }

    boolean isConnected() {
        return this.m_control != null;
    }
}

